#! /bin/bash

# Resource config
# declare -a gpu_list=(0 1 2 3 4 5 6 7)
# declare -a cpu_list=("0-7" "8-15" "16-31" "32-39" "40-47" "48-55" "56-63" "64-72")
declare -a gpu_list=(2 3)
declare -a cpu_list=("16-31" "32-39")

pool_size=${#gpu_list[@]}
host_name=`uname -n`

data_name=ogbn-products

#########################

# # core config

# # model_name="SAGE"
# model_name="RevGNN-112"
# GNN_target_path=../result/${data_name}/${model_name}/seed_1
# ## SDMP config
# SDMP_config_root=../config/${data_name}/SDMP
# # declare -a SDMP_config_name=("${data_name}_SDMP_${model_name}_tune_1.yml" "${data_name}_SDMP_${model_name}_tune_2.yml")
# declare -a SDMP_config_name=("${data_name}_SDMP_${model_name}_tune_1.yml" "${data_name}_SDMP_${model_name}_tune_2.yml" "${data_name}_SDMP_${model_name}_tune_3.yml")
# SDMP_root_result_path=../result/${data_name}_${model_name}_SDMP
# ## test config
# # declare -a TEST_config_name=("${data_name}_test_SDMP0_normed_partial_test.yml")
# declare -a TEST_config_name=("${data_name}_distill_test_SDMP0_normed.yml")
# TEST_config_root=../config/${data_name}
# TEST_root_result_path=../result/${data_name}_${model_name}_MLP_TEST

# source ./source_gen_SDMP_conf_loop.sh
# source ./source_test_MLP_conf_loop.sh

# seed looping
# core config
# declare -a model_name_pool=("SAGE" "RevGNN-112")
declare -a model_name_pool=("RevGNN-112")
# declare -a GNN_target_seed=(0 1 2 3 4 5 6 7 8 9)
declare -a GNN_target_seed=(5 6 7 8 9)

for ((model_idx=0; model_idx<${#model_name_pool[@]}; ++model_idx)); do
    model_name=${model_name_pool[$model_idx]}

    GNN_target_path_root=../result/${data_name}/${model_name}/seed_
    ## SDMP config
    SDMP_config=../config/${data_name}/SDMP/${data_name}_SDMP_${model_name}.yml
    SDMP_root_result_path=../result/${data_name}_${model_name}_SDMP
    ## test config
    # declare -a TEST_config_name=("${data_name}_MLP_SDMP_${model_name}.yml")
    declare -a TEST_config_name=("${data_name}_distill_SDMP.yml")
    TEST_config_root=../config/${data_name}
    TEST_root_result_path=../result/best/${data_name}_${model_name}_MLP_TEST

    source ./source_gen_SDMP_seed_loop.sh
    source ./source_test_MLP_seed_loop.sh
done